public struct AxisCount { public int even; public int odd; }
internal class Program {
    static void Main(string[] args) {
        int count = int.Parse(Console.ReadLine());
        Dictionary<long, int> hashmap1 = new Dictionary<long, int>();
        Dictionary<long, int> hashmap2 = new Dictionary<long, int>();
        Dictionary<long, AxisCount> hashmapX = new Dictionary<long, AxisCount>();
        Dictionary<long, AxisCount> hashmapY = new Dictionary<long, AxisCount>();

        for (int i = 0; i < count; i++) {
            string[] inputs = Console.ReadLine().Split();
            long x = long.Parse(inputs[0]);
            long y = long.Parse(inputs[1]);
            hashmap1[x - y] = 1 + hashmap1.GetValueOrDefault(x - y, 0);
            hashmap2[x + y] = 1 + hashmap2.GetValueOrDefault(x + y, 0);
            if (!hashmapX.ContainsKey(x)) hashmapX[x] = new AxisCount();
            if (!hashmapY.ContainsKey(y)) hashmapY[y] = new AxisCount();
            AxisCount axisCountX = hashmapX[x];
            AxisCount axisCountY = hashmapY[y];
            if (y % 2 == 0) axisCountX.even++;
            else axisCountX.odd++;
            if (x % 2 == 0) axisCountY.even++;
            else axisCountY.odd++;
            hashmapX[x] = axisCountX;
            hashmapY[y] = axisCountY;
        }

        long greetings = 0;
        foreach (int coordCount in hashmap1.Values)
            greetings += coordCount * (coordCount - 1);
        foreach (int coordCount in hashmap2.Values)
            greetings += coordCount * (coordCount - 1);
        foreach (AxisCount coordCount in hashmapX.Values)
            greetings += (coordCount.even * (coordCount.even - 1) + coordCount.odd * (coordCount.odd - 1)) / 2;
        foreach (AxisCount coordCount in hashmapY.Values)
            greetings += (coordCount.even * (coordCount.even - 1) + coordCount.odd * (coordCount.odd - 1)) / 2;

        Console.WriteLine(greetings);
    }
}